/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNGReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNGReader.class);
    private static final int CANON_TAG = 34665;
    private static final int TIFF_EPS_STANDARD = 37398;
    private static final int COLOR_MAP = 33422;
    private static final int WHITE_BALANCE_RGB_COEFFS = 16385;
    protected IFD original;
    private double[] whiteBalance;
    private Object cfaPattern;
    private byte[] lastPlane = null;
    private int lastIndex = -1;

    public DNGReader() {
        super("DNG", new String[]{"cr2", "crw", "jpg", "thm", "wav", "tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        boolean hasEPSTag = ifd.containsKey(37398);
        if (!hasEPSTag) {
            hasEPSTag = ifd.containsKey(34665);
        }
        String make = ifd.getIFDTextValue(271);
        String model = ifd.getIFDTextValue(272);
        return make != null && make.indexOf("Canon") != -1 && hasEPSTag && (model == null || !model.endsWith("S1 IS"));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        IFD ifd = (IFD)this.ifds.get(no);
        int[] bps = ifd.getBitsPerSample();
        int dataSize = bps[0];
        long[] byteCounts = ifd.getStripByteCounts();
        long totalBytes = 0L;
        for (long b : byteCounts) {
            totalBytes += b;
        }
        if (totalBytes == (long)FormatTools.getPlaneSize(this) || bps.length > 1) {
            byte[] b = new byte[buf.length / 2];
            this.tiffParser.getSamples((IFD)this.ifds.get(0), b, x, y, w, h);
            for (int i = 0; i < b.length; ++i) {
                int c = this.isInterleaved() ? i % 3 : i / (b.length / 3);
                short v = (short)(b[i] & 0xFF);
                v = this.adjustForWhiteBalance(v, c);
                DataTools.unpackBytes(v, buf, i * 2, 2, this.isLittleEndian());
            }
            return buf;
        }
        if (this.lastPlane == null || this.lastIndex != no) {
            long[] offsets = ifd.getStripOffsets();
            ByteArrayOutputStream src = new ByteArrayOutputStream();
            for (int i = 0; i < byteCounts.length; ++i) {
                byte[] t = new byte[(int)byteCounts[i]];
                this.in.seek(offsets[i]);
                this.in.read(t);
                src.write(t);
            }
            int[] colorMap = new int[]{1, 0, 2, 1};
            short[] ifdColors = (short[])ifd.get(33422);
            if (ifdColors != null && ifdColors.length >= colorMap.length) {
                int q;
                boolean colorsValid = true;
                for (q = 0; q < colorMap.length; ++q) {
                    if (ifdColors[q] >= 0 && ifdColors[q] <= 2) continue;
                    colorsValid = false;
                    break;
                }
                if (colorsValid) {
                    for (q = 0; q < colorMap.length; ++q) {
                        colorMap[q] = ifdColors[q];
                    }
                }
            }
            this.lastPlane = new byte[FormatTools.getPlaneSize(this)];
            BitBuffer bb = new BitBuffer(src.toByteArray());
            src.close();
            short[] pix = new short[this.getSizeX() * this.getSizeY() * 3];
            for (int row = 0; row < this.getSizeY(); ++row) {
                int realRow = row;
                for (int col = 0; col < this.getSizeX(); ++col) {
                    short val = (short)(bb.getBits(dataSize) & 0xFFFF);
                    int mapIndex = realRow % 2 * 2 + col % 2;
                    int redOffset = realRow * this.getSizeX() + col;
                    int greenOffset = (this.getSizeY() + realRow) * this.getSizeX() + col;
                    int blueOffset = (2 * this.getSizeY() + realRow) * this.getSizeX() + col;
                    if (colorMap[mapIndex] == 0) {
                        pix[redOffset] = this.adjustForWhiteBalance(val, 0);
                        continue;
                    }
                    if (colorMap[mapIndex] == 1) {
                        pix[greenOffset] = this.adjustForWhiteBalance(val, 1);
                        continue;
                    }
                    if (colorMap[mapIndex] != 2) continue;
                    pix[blueOffset] = this.adjustForWhiteBalance(val, 2);
                }
            }
            ImageTools.interpolate(pix, buf, colorMap, this.getSizeX(), this.getSizeY(), this.isLittleEndian());
            this.lastIndex = no;
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType()) * 3;
        int rowLen = w * bpp;
        int width = this.getSizeX() * bpp;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(this.lastPlane, (row + y) * width + x * bpp, buf, row * rowLen, rowLen);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.original = null;
            this.whiteBalance = null;
            this.cfaPattern = null;
            this.lastPlane = null;
            this.lastIndex = -1;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core[0].imageCount = this.ifds.size();
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        boolean bl = this.core[0].rgb = samples > 1 || photo == PhotoInterp.RGB || photo == PhotoInterp.CFA_ARRAY;
        if (photo == PhotoInterp.CFA_ARRAY) {
            samples = 3;
        }
        this.core[0].sizeX = (int)firstIFD.getImageWidth();
        this.core[0].sizeY = (int)firstIFD.getImageLength();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.size();
        this.core[0].pixelType = 3;
        this.core[0].indexed = false;
        IFDList exifIFDs = this.tiffParser.getExifIFDs();
        if (exifIFDs.size() > 0) {
            IFD exifIFD = (IFD)exifIFDs.get(0);
            this.tiffParser.fillInIFD(exifIFD);
            for (Integer key : exifIFD.keySet()) {
                int tag = key;
                String name = IFD.getIFDTagName(tag);
                if (tag == 41730) {
                    byte[] cfa = (byte[])exifIFD.get(key);
                    int[] colorMap = new int[cfa.length];
                    for (int i = 0; i < cfa.length; ++i) {
                        colorMap[i] = cfa[i];
                    }
                    this.addGlobalMeta(name, colorMap);
                    this.cfaPattern = colorMap;
                    continue;
                }
                this.addGlobalMeta(name, exifIFD.get(key));
                if (!name.equals("MAKER_NOTE")) continue;
                byte[] b = (byte[])exifIFD.get(key);
                int offset = DataTools.bytesToInt(b, b.length - 4, this.isLittleEndian());
                byte[] buf = new byte[b.length + offset - 8];
                System.arraycopy(b, b.length - 8, buf, 0, 8);
                System.arraycopy(b, 0, buf, offset, b.length - 8);
                RandomAccessInputStream makerNote = new RandomAccessInputStream(buf);
                TiffParser tp = new TiffParser(makerNote);
                IFD note = null;
                try {
                    note = tp.getFirstIFD();
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to parse first IFD", e);
                }
                if (note != null) {
                    for (Integer nextKey : note.keySet()) {
                        int nextTag = nextKey;
                        this.addGlobalMeta(name, note.get(nextKey));
                        if (nextTag != 16385) continue;
                        if (note.get(nextTag) instanceof TiffRational[]) {
                            TiffRational[] wb = (TiffRational[])note.get(nextTag);
                            this.whiteBalance = new double[wb.length];
                            for (int i = 0; i < wb.length; ++i) {
                                this.whiteBalance[i] = wb[i].doubleValue();
                            }
                            continue;
                        }
                        this.whiteBalance = new double[3];
                        this.whiteBalance[0] = 2.391381;
                        this.whiteBalance[1] = 0.929156;
                        this.whiteBalance[2] = 1.298254;
                    }
                }
                makerNote.close();
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.original = (IFD)this.ifds.get(0);
        if (this.cfaPattern != null) {
            this.original.putIFDValue(320, (int[])this.cfaPattern);
        }
        this.ifds.set(0, this.original);
        this.core[0].imageCount = 1;
        this.core[0].sizeT = 1;
        if (((IFD)this.ifds.get(0)).getSamplesPerPixel() == 1) {
            this.core[0].interleaved = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private short adjustForWhiteBalance(short val, int index) {
        if (this.whiteBalance != null && this.whiteBalance.length == 3) {
            return (short)((double)val * this.whiteBalance[index]);
        }
        return val;
    }
}

