/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.ND2Handler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.helpers.DefaultHandler;

public class NikonElementsTiffReader
extends BaseTiffReader {
    private static final int NIKON_XML_TAG = 65332;
    private static final int NIKON_XML_TAG_2 = 65333;
    private ND2Handler handler;

    public NikonElementsTiffReader() {
        super("Nikon Elements TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(65332);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.handler = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int open;
        super.initStandardMetadata();
        String xml = ((IFD)this.ifds.get(0)).getIFDTextValue(65332).trim();
        if (xml.length() == 0) {
            xml = ((IFD)this.ifds.get(0)).getIFDTextValue(65333).trim();
        }
        if ((open = xml.indexOf("<")) >= 0) {
            xml = xml.substring(open);
        }
        xml = "<NIKON>" + xml + "</NIKON>";
        xml = XMLTools.sanitizeXML(xml);
        this.handler = new ND2Handler(this.core, false, this.getImageCount());
        try {
            XMLTools.parseXML(xml, (DefaultHandler)this.handler);
            Hashtable<String, Object> globalMetadata = this.handler.getMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key, globalMetadata.get(key));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void initMetadataStore() throws FormatException {
        Double mag;
        Double na;
        Double voltage;
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String date = this.handler.getDate();
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        Double pixelSizeX = this.handler.getPixelSizeX();
        Double pixelSizeY = this.handler.getPixelSizeY();
        Double pixelSizeZ = this.handler.getPixelSizeZ();
        if (pixelSizeX > 0.0) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(pixelSizeX), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", pixelSizeX);
        }
        if (pixelSizeY > 0.0) {
            store.setPixelsPhysicalSizeY(new PositiveFloat(pixelSizeY), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", pixelSizeY);
        }
        if (pixelSizeZ > 0.0) {
            store.setPixelsPhysicalSizeZ(new PositiveFloat(pixelSizeZ), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", pixelSizeZ);
        }
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        store.setImageInstrumentRef(instrument, 0);
        ArrayList<Double> exposureTimes = this.handler.getExposureTimes();
        ArrayList<Double> posX = this.handler.getXPositions();
        ArrayList<Double> posY = this.handler.getYPositions();
        ArrayList<Double> posZ = this.handler.getZPositions();
        for (int i = 0; i < this.getImageCount(); ++i) {
            int c = this.getZCTCoords(i)[1];
            if (c < exposureTimes.size()) {
                store.setPlaneExposureTime(exposureTimes.get(c), 0, i);
            }
            if (i < posX.size()) {
                store.setPlanePositionX(posX.get(i), 0, i);
            }
            if (i < posY.size()) {
                store.setPlanePositionY(posY.get(i), 0, i);
            }
            if (i >= posZ.size()) continue;
            store.setPlanePositionZ(posZ.get(i), 0, i);
        }
        String detector = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detector, 0, 0);
        store.setDetectorModel(this.handler.getCameraModel(), 0, 0);
        store.setDetectorType(this.getDetectorType("Other"), 0, 0);
        ArrayList<String> channelNames = this.handler.getChannelNames();
        ArrayList<String> modality = this.handler.getModalities();
        ArrayList<String> binning = this.handler.getBinnings();
        ArrayList<Double> speed = this.handler.getSpeeds();
        ArrayList<Double> gain = this.handler.getGains();
        ArrayList<Double> temperature = this.handler.getTemperatures();
        ArrayList<Integer> exWave = this.handler.getExcitationWavelengths();
        ArrayList<Integer> emWave = this.handler.getEmissionWavelengths();
        ArrayList<Integer> power = this.handler.getPowers();
        ArrayList<Hashtable<String, String>> rois = this.handler.getROIs();
        Double pinholeSize = this.handler.getPinholeSize();
        for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
            if (pinholeSize != null) {
                store.setChannelPinholeSize(pinholeSize, 0, c);
            }
            if (c < channelNames.size()) {
                store.setChannelName(channelNames.get(c), 0, c);
            }
            if (c < modality.size()) {
                store.setChannelAcquisitionMode(this.getAcquisitionMode(modality.get(c)), 0, c);
            }
            if (c < emWave.size()) {
                if (emWave.get(c) > 0) {
                    store.setChannelEmissionWavelength(new PositiveInteger(emWave.get(c)), 0, c);
                } else {
                    LOGGER.warn("Expected positive value for EmissionWavelength; got {}", emWave.get(c));
                }
            }
            if (c < exWave.size()) {
                if (exWave.get(c) > 0) {
                    store.setChannelExcitationWavelength(new PositiveInteger(exWave.get(c)), 0, c);
                } else {
                    LOGGER.warn("Expected positive value for ExcitationWavelength; got {}", exWave.get(c));
                }
            }
            if (c < binning.size()) {
                store.setDetectorSettingsBinning(this.getBinning(binning.get(c)), 0, c);
            }
            if (c < gain.size()) {
                store.setDetectorSettingsGain(gain.get(c), 0, c);
            }
            if (c < speed.size()) {
                store.setDetectorSettingsReadOutRate(speed.get(c), 0, c);
            }
            store.setDetectorSettingsID(detector, 0, c);
        }
        if (temperature.size() > 0) {
            store.setImagingEnvironmentTemperature(temperature.get(0), 0);
        }
        if ((voltage = this.handler.getVoltage()) != null) {
            store.setDetectorSettingsVoltage(voltage, 0, 0);
        }
        if ((na = this.handler.getNumericalAperture()) != null) {
            store.setObjectiveLensNA(na, 0, 0);
        }
        if ((mag = this.handler.getMagnification()) != null) {
            store.setObjectiveCalibratedMagnification(mag, 0, 0);
        }
        store.setObjectiveModel(this.handler.getObjectiveModel(), 0, 0);
        String immersion = this.handler.getImmersion();
        if (immersion == null) {
            immersion = "Other";
        }
        store.setObjectiveImmersion(this.getImmersion(immersion), 0, 0);
        String correction = this.handler.getCorrection();
        if (correction == null || correction.length() == 0) {
            correction = "Other";
        }
        store.setObjectiveCorrection(this.getCorrection(correction), 0, 0);
        String objective = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveSettingsID(objective, 0);
        Double refractiveIndex = this.handler.getRefractiveIndex();
        if (refractiveIndex != null) {
            store.setObjectiveSettingsRefractiveIndex(refractiveIndex, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        this.handler.populateROIs(store);
    }
}

