/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import loci.common.RandomAccessInputStream;

public class OnDemandLongArray {
    private RandomAccessInputStream stream;
    private int size;
    private long start;

    public OnDemandLongArray(RandomAccessInputStream in) throws IOException {
        this.stream = in;
        this.start = this.stream.getFilePointer();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long get(int index) throws IOException {
        long fp = this.stream.getFilePointer();
        this.stream.seek(this.start + (long)(index * 8));
        long value = this.stream.readLong();
        this.stream.seek(fp);
        return value;
    }

    public long size() {
        return this.size;
    }

    public void close() throws IOException {
        this.stream.close();
        this.stream = null;
        this.size = 0;
        this.start = 0L;
    }
}

