/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceType;

public class LocalDatasetSource
extends DatasetSource {
    private static Logger logger = LoggerFactory.getLogger(LocalDatasetSource.class);
    private File accessPointHeaderFile = null;
    private File accessPointFile = null;

    LocalDatasetSource() {
        this.type = DatasetSourceType.getType("Local");
    }

    protected InvDataset createDataset(String datasetLocation, String prefixUrlPath) throws IOException {
        if (datasetLocation == null) {
            throw new NullPointerException("Dataset location cannot be null.");
        }
        this.checkAccessPoint();
        return new LocalInvDataset(null, new File(datasetLocation), prefixUrlPath);
    }

    protected InvCatalog createSkeletonCatalog(String prefixUrlPath) throws IOException {
        this.checkAccessPoint();
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        InvService service = new InvService(this.getResultService().getName(), this.getResultService().getServiceType().toString(), this.getResultService().getBase(), this.getResultService().getSuffix(), this.getResultService().getDescription());
        Iterator<Object> it = this.getResultService().getProperties().iterator();
        while (it.hasNext()) {
            service.addProperty(it.next());
        }
        it = this.getResultService().getServices().iterator();
        while (it.hasNext()) {
            service.addService((InvService)it.next());
        }
        catalog.addService(service);
        File apFile = new File(this.getAccessPoint());
        LocalInvDataset topDs = new LocalInvDataset(null, apFile, prefixUrlPath);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(service.getName());
        InvMetadata md = new InvMetadata(topDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        topDs.setLocalMetadata(tm2);
        catalog.addDataset(topDs);
        catalog.finish();
        return catalog;
    }

    private void checkAccessPoint() throws IOException {
        if (this.accessPointHeaderFile == null) {
            File aphFile = new File(this.getResultService().getAccessPointHeader());
            if (!aphFile.exists()) {
                throw new IOException("The accessPointHeader local file does not exist <" + aphFile.getPath() + ">.");
            }
            File apFile = new File(this.getAccessPoint());
            if (!apFile.exists()) {
                throw new IOException("The accessPoint local file does not exist <" + apFile.getPath() + ">.");
            }
            if (!apFile.isDirectory()) {
                throw new IOException("The accessPoint local file is not a directory <" + apFile.getPath() + ">.");
            }
            if (!apFile.getPath().startsWith(aphFile.getPath()) && !apFile.getCanonicalPath().startsWith(aphFile.getCanonicalPath())) {
                String tmpMsg = "The accessPoint <" + apFile.getPath() + " or " + apFile.getCanonicalPath() + "> must start with the accessPointHeader <" + aphFile.getPath() + " or " + aphFile.getCanonicalPath() + ">.";
                logger.debug("checkAccessPoint(): {}", (Object)tmpMsg);
                throw new IOException(tmpMsg);
            }
            this.accessPointHeaderFile = aphFile;
            this.accessPointFile = apFile;
        }
    }

    protected boolean isCollection(InvDataset dataset) {
        return ((LocalInvDataset)dataset).isDirectory();
    }

    protected List expandThisLevel(InvDataset dataset, String prefixUrlPath) {
        if (dataset == null) {
            throw new NullPointerException("Given dataset cannot be null.");
        }
        if (!this.isCollection(dataset)) {
            throw new IllegalArgumentException("Dataset \"" + dataset.getName() + "\" is not a collection dataset.");
        }
        File theDir = new File(((LocalInvDataset)dataset).getLocalPath());
        File[] allFiles = theDir.listFiles();
        LocalInvDataset curDs = null;
        ArrayList<LocalInvDataset> list = new ArrayList<LocalInvDataset>();
        for (int i = 0; i < allFiles.length; ++i) {
            try {
                curDs = new LocalInvDataset(dataset, allFiles[i], prefixUrlPath);
            }
            catch (IOException e) {
                continue;
            }
            list.add(curDs);
        }
        return list;
    }

    private class LocalInvDataset
    extends InvDatasetImpl {
        private String relativePath;
        private String catRelativePath;
        private String localPath;
        private boolean directory;

        LocalInvDataset(InvDataset parent, File file2, String prefixUrlPath) throws IOException {
            String dsName;
            int index;
            super((InvDatasetImpl)parent, null, null, null, null);
            if (logger.isDebugEnabled()) {
                logger.debug("LocalInvDataset(): parent=" + (parent == null ? "" : parent.getName()) + "; file=" + file2.getPath());
            }
            if (!file2.exists()) {
                throw new IOException("File <" + file2.getPath() + "> does not exist.");
            }
            this.directory = file2.isDirectory();
            String uriStringFromFile = file2.toURI().toString();
            String uriStringFromCanonicalFile = file2.getCanonicalFile().toURI().toString();
            String aphUriStringFromFile = LocalDatasetSource.this.accessPointHeaderFile.toURI().toString();
            String aphUriStringFromCanonicalFile = LocalDatasetSource.this.accessPointHeaderFile.getCanonicalFile().toURI().toString();
            String apUriStringFromFile = LocalDatasetSource.this.accessPointFile.toURI().toString();
            String apUriStringFromCanonicalFile = LocalDatasetSource.this.accessPointFile.getCanonicalFile().toURI().toString();
            this.relativePath = null;
            if (logger.isDebugEnabled()) {
                logger.debug("LocalInvDataset():               file URI=" + uriStringFromFile);
                logger.debug("LocalInvDataset():     canonical file URI=" + uriStringFromCanonicalFile);
                logger.debug("LocalInvDataset():           aph file URI=" + aphUriStringFromFile);
                logger.debug("LocalInvDataset(): aph canonical file URI=" + aphUriStringFromCanonicalFile);
            }
            if (!uriStringFromFile.startsWith(aphUriStringFromFile)) {
                if (!uriStringFromCanonicalFile.startsWith(aphUriStringFromCanonicalFile)) {
                    String tmpMsg = "File <" + uriStringFromFile + " or " + uriStringFromCanonicalFile + "> must start with accessPointHeader <" + aphUriStringFromFile + " or " + aphUriStringFromCanonicalFile + ">.";
                    throw new IOException(tmpMsg);
                }
                this.relativePath = uriStringFromCanonicalFile.substring(aphUriStringFromCanonicalFile.length());
                this.catRelativePath = uriStringFromCanonicalFile.substring(apUriStringFromCanonicalFile.length());
                this.localPath = file2.getCanonicalPath();
            } else {
                this.relativePath = uriStringFromFile.substring(aphUriStringFromFile.length());
                this.catRelativePath = uriStringFromFile.substring(apUriStringFromFile.length());
                this.localPath = file2.getAbsolutePath();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("LocalInvDataset():           relativePath=" + this.relativePath);
                logger.debug("LocalInvDataset():              localPath=" + this.localPath);
            }
            if (!this.directory) {
                if (LocalDatasetSource.this.getResultService().getBase().equals("") && !LocalDatasetSource.this.getResultService().getServiceType().equals(ServiceType.COMPOUND)) {
                    this.setUrlPath(this.catRelativePath);
                } else {
                    String tmpUrlPath = prefixUrlPath == null || prefixUrlPath.equals("") ? this.relativePath : prefixUrlPath + "/" + this.relativePath;
                    this.setUrlPath(tmpUrlPath);
                }
                if (LocalDatasetSource.this.isAddDatasetSize()) {
                    this.setDataSize(file2.length());
                }
            }
            if ((index = (dsName = this.relativePath.endsWith("/") ? this.relativePath.substring(0, this.relativePath.length() - 1) : this.relativePath).lastIndexOf("/")) != -1) {
                dsName = dsName.substring(index + 1);
            }
            this.setName(dsName);
        }

        String getLocalPath() {
            return this.localPath;
        }

        void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public boolean isDirectory() {
            return this.directory;
        }
    }
}

