function Xout=interpolateProfile2(V,method,extrapval,maxRange)
    
    if nargin<2
        method='linear';
    end
    if nargin<3
        extrapval=NaN;
    end
    if nargin<4
        maxRange=10;
    end
    
    nanDist=bwdist(V==0);
    
    nanVals=V==0;
    nanCoords=find(nanVals);
    [xMesh,yMesh]=meshgrid(1:size(V,2), 1:size(V,1));
    Xout=double(V);
    
    cut=nanDist>0 & nanDist<maxRange;
    
    Xcut=xMesh(cut);
    Ycut=yMesh(cut);
    Vcut=double(V(cut));
    
    F=scatteredInterpolant(Xcut,Ycut,Vcut,method);
    
    Xout(nanCoords)=F(xMesh(nanCoords), yMesh(nanCoords));
    