
set infile [open ssrestraints.txt r]


while { [gets $infile line] != -1 } {

  if {[lindex $line 0] == "dihedral"} {
    set index1 [lindex $line 1]
    set index2 [lindex $line 2]
    set index3 [lindex $line 3]
    set index4 [lindex $line 4]

    set sel1 [atomselect top "index $index1"]
    set sel2 [atomselect top "index $index2"]
    set sel3 [atomselect top "index $index3"]
    set sel4 [atomselect top "index $index4"]    

    set pos1 [measure center $sel1]
    set pos2 [measure center $sel2]
    set pos3 [measure center $sel3]
    set pos4 [measure center $sel4]

    graphics top color black
    graphics top sphere $pos1 radius 0.2 resolution 10
    graphics top sphere $pos2 radius 0.2 resolution 10
    graphics top sphere $pos3 radius 0.2 resolution 10
    graphics top sphere $pos4 radius 0.2 resolution 10

    graphics top color lime
    graphics top cylinder $pos1 $pos2 radius 0.1 resolution 10
    graphics top cylinder $pos2 $pos3 radius 0.1 resolution 10
    graphics top cylinder $pos3 $pos4 radius 0.1 resolution 10

    $sel1 delete
    $sel2 delete 
    $sel3 delete
    $sel4 delete
  }

  if {[lindex $line 0] == "bond"} {
    set index1 [lindex $line 1]
    set index2 [lindex $line 2]
   
    set sel1 [atomselect top "index $index1"]
    set sel2 [atomselect top "index $index2"]
 
    set pos1 [measure center $sel1]
    set pos2 [measure center $sel2]

    graphics top color black
    graphics top sphere $pos1 radius 0.2 resolution 10
    graphics top sphere $pos2 radius 0.2 resolution 10

    graphics top color purple
    graphics top cylinder $pos1 $pos2 radius 0.1 resolution 10

    $sel1 delete
    $sel2 delete

  }

}

close $infile


#exit
