set loadstep 25
set timestep 2
set dcdfreq 1000
set nsperframe [expr $loadstep*$timestep*$dcdfreq/1000000.0]

mol load psf ../../ionized.psf pdb ../../ionized.pdb

mol addfile ../eq-ConstructModel-Step25-00.dcd step [expr $loadstep / 25] waitfor all


#source /home/jhsin/scripts/unwrap_v1.2a.tcl
#unwrap protein

set outfile [open BuriedSurfAll.dat w] 	 
	 
set sel1 [atomselect top "protein and resid 1 to 224 441 to 664"] 	 
set sel2 [atomselect top "protein and resid 230 to 425"] 
set sel3 [atomselect top "protein and resid 1 to 224 441 to 664 230 to 425"]

set nf [molinfo top get numframes] 

for { set i 1 } { $i <= $nf } { incr i } { 	 
  puts "$i out of $nf"
  $sel1 frame $i 	 
  $sel2 frame $i 
  $sel3 frame $i 

  set A [measure sasa 1.4 $sel3]

  set B [measure sasa 1.4 $sel1]

  set C [measure sasa 1.4 $sel2]

  puts $outfile "[expr $i*$nsperframe] [expr ($B+$C-$A)/2]" 	 
	 
} 	 
close $outfile
exit
